<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\Post\Like;

use Erlage\Photogram\System;
use Erlage\Photogram\Data\Tables\Post\PostLikeTable;
use Erlage\Photogram\Data\Models\InterfaceModelBuilder;

final class PostLikeBuilder implements InterfacePostLikeSetter, InterfaceModelBuilder
{
    /**
     * setter interface
     */
    use TraitPostLikeSetters;

    /*
    |--------------------------------------------------------------------------
    | default values
    |--------------------------------------------------------------------------
    */

    /**
     * @var array
     */
    public $defaultValues;

    public function __construct()
    {
        $this -> defaultValues = self::defaultValues();
    }

    public static function defaultValues(): array
    {
        return array(
            PostLikeTable::LIKED_POST_ID     => '',
            PostLikeTable::LIKED_BY_USER_ID  => '',

            PostLikeTable::STAMP_REGISTRATION => System::isoDateTime(),
            PostLikeTable::STAMP_LAST_UPDATE  => System::isoDateTime(),
        );
    }

    public function dispense(): PostLikeModel
    {
        return PostLikeModel::createFromData(
            array(
                // liked post id

                PostLikeTable::LIKED_POST_ID => $this -> likedPostId

                ?? $this -> defaultValues[PostLikeTable::LIKED_POST_ID],

                // liked by user id

                PostLikeTable::LIKED_BY_USER_ID  => $this -> likedByUserId

                ?? $this -> defaultValues[PostLikeTable::LIKED_BY_USER_ID],

                // stamp registration

                PostLikeTable::STAMP_REGISTRATION => $this -> stampRegistration

                ?? $this -> defaultValues[PostLikeTable::STAMP_REGISTRATION],

                // stamp last update

                PostLikeTable::STAMP_LAST_UPDATE  => $this -> stampLastUpdate

                ?? $this -> defaultValues[PostLikeTable::STAMP_LAST_UPDATE],
            )
        );
    }
}
